/************************************************************************
 *
 * \file: iAP2EANativeSession.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Baidu Carlife - Demo application
 *
 * \author: Ajay Kumar Sahoo / ajaykumar.sahoo@in.bosch.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef BDCL_IAP2EANATIVESESSION_H
#define BDCL_IAP2EANATIVESESSION_H

#include <pthread_adit.h>
#include <string>

#include <iap2_init.h>
#include <iap2_initialize_usb_gadget.h>

#include "EventDispatcher.h"

namespace adit { namespace bdcl {

//#
//# Configuration file for IPOD_AUTHENTICATION
//#

#define IPOD_AUTH_DEV_NAME                    "/dev/i2c-1"
//# register address in dec instead hex (0x11 -> 17)
#define IPOD_AUTH_IOCTL_REG                   "17"
//# GPIO port
//#define IPOD_AUTH_GPIO_RESET                  "508"
#define IPOD_AUTH_GPIO_RESET                  "-1" //for copro 2.0c
#define IPOD_AUTH_GPIO_READY                  "-1"
//# timeouts
#define IPOD_AUTH_DEV_COM_SHORT_WAIT          1
#define IPOD_AUTH_DEV_COM_WAIT                10
#define IPOD_AUTH_DEV_COM_LONG_WAIT           50

#define BDCL_IAP2_APP_NAME                                    "com.baidu.CarLifeVehicleProtocol"
#define BDCL_IAP2_BUNDLE_ID                                   "com.baidu.lbs.CarLife"

//#define MYSPIN_MQ_MAX_SIZE                                          1024
//#define MYSPIN_MQ_NAME                                              "/mySPIN_Mq"
//#define MYSPIN_MQ_NAME_APP_TSK                                      "/mySPIN_TskMq"
//#define MYSPIN_MQ_CMD_STOP_POLL                                     "mqStopPoll"

#define BDCL_IAP2_ACC_INFO_NAME                              "AmazingProduct"
#define BDCL_IAP2_ACC_INFO_MODEL_IDENTIFIER                  "15697"
#define BDCL_IAP2_ACC_INFO_MANUFACTURER                      "ADIT"
#define BDCL_IAP2_ACC_INFO_SERIAL_NUM                        "12345678"
#define BDCL_IAP2_ACC_INFO_FW_VER                            "1"
#define BDCL_IAP2_ACC_INFO_HW_VER                            "1"
#define BDCL_IAP2_ACC_INFO_VENDOR_ID                         "44311"
#define BDCL_IAP2_ACC_INFO_PRODUCT_ID                        "1111"
#define BDCL_IAP2_ACC_INFO_BCD_DEVICE                        "1"
#define BDCL_IAP2_ACC_INFO_INIT_ENDPOINT                     "/dev/ffs/ep0"

#define BDCL_IAP2_ACC_CONFG_TRANS_USB_OTG_GPIO_POWER_SD      "86"
#define BDCL_IAP2_ACC_CONFG_TRANS_USB_OTG_GPIO_POWER_AI      "425"



class iAP2EANativeSession
{
public:
    iAP2EANativeSession (std::string iap2devserial,EventDispatcher  *DevEventDispatcher);
    ~iAP2EANativeSession();
    int32_t iAP2EASessionInit(void);
    int32_t iAP2EASessionDeInit(void);

protected:
    //some utility functions
    int32_t iAP2UtilCopyString(uint8_t* pString, uint8_t** ppDestination);


private:

    int32_t iAP2ConfigureAccessory();
    void iAP2ConfigureAccessoryBasics(iAP2AccessoryConfig_t* pConfig);
    int32_t iAP2ConfigureAccInfo(iAP2AccessoryInfo_t* pAccInfo, iAP2TransportType_t transportType);
    void iAP2ConfigureSessionCallbacks(iAP2SessionCallbacks_t* pCallbacks);
    void iAP2ConfigureStackCallbacks(iAP2StackCallbacks_t* pStackCallbacks);
    void iAP2ConfigureEANativeTransportCallbacks(iAP2EANativeTransportCallbacks_t* pEANativeTransportCallbacks);
    void iAP2ParseIdRejectedMsg(iAP2IdentificationRejectedParameter* idParameter);

    void iAP2DeConfigureAccessory();
    void iAP2FreeAccConfig(iAP2AccessoryConfig_t* p_iAP2AccessoryConfig);
    void iAP2FreeAccInfo(iAP2AccessoryInfo_t *pAccInfo);
    int32_t  iAP2SendPowerSourceUpdate(void);
    int32_t  iAP2RequestBaiduAppLaunch(bool withAlert);

    static int32_t iAP2UpdateDeviceStateCB(iAP2Device_t* iap2Device, iAP2DeviceState_t state, void* context);
    static int32_t iAP2StartEANativeTransportCB(iAP2Device_t* iap2Device, uint8_t iAP2iOSAppIdentifier, uint8_t sinkEndpoint, uint8_t sourceEndpoint, void* context);
    static int32_t iAP2StopEANativeTransportCB(iAP2Device_t* iap2Device, uint8_t iAP2iOSAppIdentifier, uint8_t sinkEndpoint, uint8_t sourceEndpoint, void* context);
    static int32_t iAP2AuthenticationFailedCB(iAP2Device_t* iap2Device, iAP2AuthenticationFailedParameter* authParameter, void* context);
    static int32_t iAP2AuthenticationSucceededCB(iAP2Device_t* iap2Device, iAP2AuthenticationSucceededParameter* authParameter, void* context);
    static int32_t iAP2IdentificationAcceptedCB(iAP2Device_t* iap2Device, iAP2IdentificationAcceptedParameter* idParameter, void* context);
    static int32_t iAP2IdentificationRejectedCB(iAP2Device_t* iap2Device, iAP2IdentificationRejectedParameter* idParameter, void* context);
    static int32_t iAP2PowerUpdateCB(iAP2Device_t* iap2Device, iAP2PowerUpdateParameter* powerupdateParameter, void* context);

    static void* iAP2PollThread(void* inData);
    static void* iAP2AppThread(void* inData);
    int32_t addFDToPollFDs(iAP2PollFDs_t* getPollFDs, int32_t numFDs, int32_t fdToAdd, int16_t eventToAdd);
    int32_t addFDsToFDset(iAP2PollFDs_t* getPollFDs, int32_t numFDs, int32_t* maxfd, fd_set* to_readfds, fd_set* to_writefds);

    bool endPoll;
    std::string  iAP2DevSerial;
    sem_t iAP2DevReady ;
    pthread_t iAP2AppThreadId ;
    pthread_t pollThreadId;
    iAP2Device_t* p_iAP2Device;
    iAP2DeviceState_t iAP2DevState;
    iAP2InitParam_t iap2initparam;
    uint16_t bdcl_demo_USBHostModeMsgSentByAcc[4] = { IAP2_MSG_ID_START_POWER_UPDATES, IAP2_MSG_ID_STOP_POWER_UPDATES,
                                                 IAP2_MSG_ID_REQUEST_APP_LAUNCH, IAP2_MSG_ID_POWER_SOURCE_UPDATE
                                               };
    uint16_t bdcl_demo_USBHostModeMsgRecvFromDevice[1] = { IAP2_MSG_ID_POWER_UPDATE  };

    EventDispatcher  *mEventDispatcher; //deligate STARTEA and STOPEA event to dispatcher

    /* eventfd added in usbMonitorThread to polling. */
    int32_t mEventFd;
};
} }/* namespace adit { namespace bdcl */
#endif /* BDCL_IAP2EANATIVESESSION_H */
